/******************************************************************************
	CTextPane.c
	
				CTextPane Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


 ******************************************************************************/


#include "CTextPane.h"
#include <Commands.h>
#include <CDocument.h>
#include <CPrinter.h>
#include <CBartender.h>
#include <Constants.h>
#include <ctype.h>
#include <CTextEnvirons.h>

#define lineWidthSameAsFrame -1

extern	CBartender	*gBartender;

#ifdef useCPEdit
long PEWordBreaker(long charPos, BreakDirection direction, CPEditText *thePEditText);

static long PEWordBreaker(long charPos, BreakDirection direction,
	CPEditText *thePEditText)
{
}


#else
pascal Boolean myWordBreaker(Ptr textPtr, short offset );

static pascal Boolean myWordBreaker(Ptr textPtr, short offset )
{
char ch;

	ch = textPtr[offset];

	/* return TRUE if ch is a break character */

	if ((ch == '_') || (isalnum(ch)))
		return( FALSE );
	else
		return( TRUE );
}

#endif

void CTextPane::ITextPane(CView *anEnclosure, CBureaucrat *aSupervisor,
	short			aWidth,
	short			aHeight,
	short			aHEncl,
	short			aVEncl,
	SizingOption	aHSizing,
	SizingOption	aVSizing)
{
	Rect		margin;
	CDocument	*doc;
	int			lineW;

	// this relies on itsPrinter (in CDocument) being already allocated
	doc = (CDocument *) aSupervisor;
	if (doc->itsPrinter) {
		Rect	paperRect;		/* The physical paper size		*/
		Rect	pageRect;		/* Printable area of the page	*/
		short	hRes;			/* Horizontal resolution		*/
		short	vRes;			/* Vertical resolution			*/
		(doc->itsPrinter)->GetPageInfo(&paperRect, &pageRect, &hRes, &vRes);
		lineW = pageRect.right - pageRect.left;
		lineW--;		/* make the lineW one pix less than page */
	}
	else
		lineW = lineWidthSameAsFrame;

#ifdef useCPEdit
	CPEditText::IPEditText(anEnclosure, aSupervisor, aWidth, aHeight,
		aHEncl, aVEncl, aHSizing, aVSizing);
#else
	CEditText::IEditText(anEnclosure, aSupervisor, aWidth, aHeight,
		aHEncl, aVEncl, aHSizing, aVSizing, lineW);
#endif


	SetTEWordBreak();
}

void	CTextPane::Activate( void)
{
	inherited::Activate();
	SetTEWordBreak();
}

void	CTextPane::SetTEWordBreak(void)
{

#ifdef useCPEdit
	//SetWordBreakHook(PEWordBreaker);
#else
	SetWordBreak(myWordBreaker, macTE);
#endif
}

long	CTextPane::GetCursorLine(void)
{
	long		selStart;		/* start of selection */
	long		selEnd;

	GetSelection(&selStart, &selEnd);
	return FindLine(selStart);
}

void	CTextPane::SelectLine(long line)
{
	long start, end;

#ifdef useCPEdit
	start = GetLineStart(line);
	end = GetLineEnd(line);
	SetSelection(start, end, true);

#else
	TEHandle te;

	te = macTE;
	line--;
	if (line < (*te)->nLines) {
		start = (*te)->lineStarts[line];
		if (line + 1 < (*te)->nLines)
			end = (*te)->lineStarts[line+1];
		else
			end = (*te)->teLength;

		SetSelection(start, end, true);
	}
#endif
}

void	CTextPane::SelectFT(long line1, long col1,
								  long line2, long col2)
{
	long start, end;

#ifdef useCPEdit

	start = GetLineStart(line1) + col1;
	end = GetLineStart(line2) + col2;
	SetSelection(start, end, true);

#else
	TEHandle te;

	te = macTE;
	line1--;
	line2--;
	if (line1 < (*te)->nLines) {
		start = (*te)->lineStarts[line1] + col1 - 1;	// inclusive
		if (line2 < (*te)->nLines)
			end = (*te)->lineStarts[line2] + col2;
		else
			end = (*te)->teLength;

		SetSelection(start, end, true);
	}
#endif
}


short	CTextPane::GetFontNum(void)
{
	// get the font from the text edit field
#ifdef useCPEdit
	TextInfoRec		textInfo;
	((CTextEnvirons *) itsEnvironment)->GetTextInfo(&textInfo);
	return textInfo.fontNumber;
#else
	return (**macTE).txFont;
#endif
}

short	CTextPane::GetFontSize(void)
{
	// get the size from the text edit field
#ifdef useCPEdit
	TextInfoRec		textInfo;
	((CTextEnvirons *) itsEnvironment)->GetTextInfo(&textInfo);
	return textInfo.theSize;
#else
	return (**macTE).txSize;
#endif
}

